
# DayOfWeek() written in a pythonic spin

Author: Fotis Georgatos <kefalonia@gmail.com>
LinkedIn: https://www.linkedin.com/in/eur-ing-fotis-georgatos/ (prefer this channel, state "IOPCC")

Highlights:
- This is classic DayOfWeek() re-written aiming pythonic brevity and elegance - clarity is everything, isn't it?
- The program should run fine on CPython versions >=3.8 like in [1] and also earlier versions. No dependencies.
- The function is generic and should serve for any Gregorian day, inspect [2].
- The provided example output names the first day of each year for the running century [3].
- The cursed part of the function is the tuple which is not a tuple at all, it just pretends to look like one.
- Effectively this is a playfull re-incarnation of Sakamoto's method; see also Zeller's Congruence algorithm variants.
- That's all folks

### [1] Python 3 version tried against

Invoked as `python3` under MacOS:
```
Python 3.9.6 (default, Nov 10 2023, 13:38:27)
[Clang 15.0.0 (clang-1500.1.0.2.5)] on darwin
```

### [2] Example usage of the function

>>> def DayOfWeek(y, m, d, tuple=' (["upseal.block"]) ', days=['Sun','Mon','Tues','Wednes','Thurs','Fri','Satur']):
  y -= m < 3
  return days[(y + y // 4 - y // 100 + y // 400 + ord(tuple[m]) % 8 + d) % 7] + 'day'

>>> DayOfWeek(2024,5,29)
'Wednesday'

### [3] Example output

% python3 DayOfWeek_simple.py
2000 Saturday
2001 Monday
2002 Tuesday
2003 Wednesday
2004 Thursday
2005 Saturday
2006 Sunday
2007 Monday
2008 Tuesday
2009 Thursday
2010 Friday
2011 Saturday
2012 Sunday
2013 Tuesday
2014 Wednesday
2015 Thursday
2016 Friday
2017 Sunday
2018 Monday
2019 Tuesday
2020 Wednesday
2021 Friday
2022 Saturday
2023 Sunday
2024 Monday
