# Author

Livin Nector at [livinnector2001@gmail.com](livinnector2001@gmail.com). 

# How to use

```bash
python3.12 _.py
```
or
```bash
python _.py
```
or
```bash
uvx --python 3.12 python _.py 
```

# Python Version

Python 3.12 (produces syntax errors in versions less than 3.12)

# Required Libraries

Only uses builtin `dataclasses` library.

# OS

Any os should work, but tested on linux.

# What it does

It prints the comments written between both `@d` decorator lines. Make sure to add a blank line above and below the comments. These comments should being in the start of the line and has a space after the '#'.

# Why it is special

- Main code runs if `__name__ != '__main__'`.
- Only digits that appear in the source code are 0 and 1.
- Uses Python 3.12+ only syntax. With 3.8 and 3.9 raises one type of syntax error, but with 3.10 and 3.11 raises a different one. Though the formatted code works in all 3.8+ versions.
- Retrives the string 'split' from a string to construct the `split` method and uses it to split the same string.

# Easter Eggs

- It is a functional source code sandwich which spills the fillings, and has:
  - *imported* crust on both sides
  - *decorated* butter spreads and
  - *commented* fillings (only commented fillings are allowed or you'll break the sandwich's syntax.).
- Has very meaningful class definitions
  - One describing the golden ratio.
  - The other describing the alphabets.
- It comes with the word finding game and it is hosted by a cow!
- Bonus Game: Try to find how different functions and methods used are retrieved using strings.
  - 'print'
  - 'read'
  - 'open'
  - 'split'
  - 'setattr'
  - 'getattr'
  - 'map'

